<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "quiz_db";

// Veido datubāzes savienojumu
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda, vai ir veiksmīga savienošanās ar datubāzi
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Iegūst skolēna ID no pieprasījuma GET parametriem
$student_id = $_GET['student_id'];

// Izgūst skolēna vārdu
$sql = "SELECT username FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();
$student = $result->fetch_assoc();
$student_name = $student['username'];

// Izgūst testa rezultātus par konkrēto skolēnu
$sql = "SELECT tests.name AS test_name, test_results.score, test_results.date 
        FROM test_results 
        JOIN tests ON test_results.test_id = tests.id 
        WHERE test_results.user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();

$results = [];
// Pārbauda, vai ir rezultāti
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $results[] = $row;
    }
}

// Izvada rezultātus kā JSON atbildi, iekļaujot skolēna vārdu un rezultātus
echo json_encode(['student_name' => $student_name, 'results' => $results]);

// Aizveram sagatavošanas komandas un datubāzes savienojumu
$stmt->close();
$conn->close();
?>
